# Add file type exclusions to Windows Defender for CLS files.
write-output "Adding Windows Defender filetype exclusions for Collage jobs."
$extensions = ".elo",".cjb",".vjb"
foreach ($i in $extensions) {
    add-mppreference -ExclusionExtension $I -force
}

# Now to update the Windows features.
write-output "Configuring Windows features."

# Disable Hyper-V
$disablefeatures = "Microsoft-Hyper-V-All"
foreach ($i in $disablefeatures) {
    dism /online /Disable-Feature /NoRestart /FeatureName:$i
}

# Enable Telnet client, SMB 1.0/CIFS support, and MSMQ HTTP, Triggers and AD Integration
$enablefeatures = "TelnetClient","SMB1Protocol-Client","SMB1Protocol-Server","SMB1Protocol-Deprecation","MSMQ-HTTP","MSMQ-Triggers","MSMQ-ADIntegration"
foreach ($i in $enableFeatures) {
    dism /online /Enable-Feature /NoRestart /All /FeatureName:$i
}

# Configure firewall rules
write-output "Configuring Windows Firewall."
# First, remove all of the rules auto-created by this script
get-netfirewallrule -name "OGT_CLS_*" -erroraction silentlycontinue | remove-netfirewallrule

# And now add the rules we need
$services = "OeeLauncher","OeeLockDaemon","OeeRipToClsService","OeeVitalProofSpooler","OeeSLService","OeeELSServer","OeePerlService"
$launched = "OeeRenderLayout","OeeImportImages","OeeGenFA","OeeMontage","OeeHistogramService"
$applications = "ImpImg","OeeCLS","OeeCLSRO","OeeTiffGenerator"

foreach ($i in $services + $launched + $applications) {
    new-netfirewallrule -Name OGT_CLS_$i -DisplayName $i -Program "C:\Program Files (x86)\Collage-S\$i.exe" -Action "Allow" -Direction "Inbound"
}

# And now the last few bits.
write-output "Preforming final configuration."

# This will globally set the execution policy since we're running as an administrator.
set-executionpolicy -executionpolicy unrestricted -force

# Enable the guest account
enable-localuser -name Guest

# Enable system restore on the system drive
enable-computerrestore -Drive "C:\" -erroraction silentlycontinue

write-host -NoNewLine "Press any key to continue..."
$null = $Host.UI.RawUI.ReadKey("NoEcho,IncludeKeyDown")
exit
